/*!
  \file
  \brief OpenAL の初期化サンプル

  \author Satofumi KAMIMURA

  www.devmaster.net/articles/openal/ より

  $Id: initialize.cpp 166 2008-08-24 00:37:24Z satofumi $
*/

#include <AL/al.h>
#include <AL/alc.h>
#include <AL/alut.h>
#include <stdio.h>


int main(int argc, char *argv[])
{
  // Initialize
  ALCdevice* device = alcOpenDevice(NULL);
  if (device == NULL) {
    printf("fail.\n");
    return 1;
  }
  ALCcontext* context = alcCreateContext(device, NULL);
  alcMakeContextCurrent(context);
  alGetError();

#if 0
  // Loading Sounds
  char* alBuffer;
  ALenum alFormatBuffer;
  ALsizei alFregBuffer;
  long alBufferLen = 0;
  ALboolean loop;
  unsigned int alSource;
  unsigned int alSampleSet;
  alutLoadWAVFile("pettan.wav", &alFormatBuffer, (void**)&alBuffer,
                  (ALsizei*)&alBufferLen, &alFregBuffer, &loop);
  alGenSources(1, &alSource);
  alBufferData(alSampleSet, alFormatBuffer,
               alBuffer, alBufferLen, alFregBuffer);
  alSourcei(alSource, AL_BUFFER, alSampleSet);
  alutUnloadWAV(alFormatBuffer, alBuffer, alBufferLen, alFregBuffer);
#endif

  // Terminate
  //alDeleteSources(1, &alSource);
  //alDeleteBuffers(1, &alSampleSet);

  alcMakeContextCurrent(NULL);
  alcDestroyContext(context);
  alcCloseDevice(device);

  printf("O.K.\n");
  return 0;
}
