// http://www.nuclex.org/articles/quick-introduction-to-luabind

extern "C" {
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


template<typename T>
struct Point {
  Point(T X, T Y) :
    X(X), Y(Y) {}

  T X, Y;
};

template<typename T>
struct Box {
  Box(Point<T> UpperLeft, Point<T> LowerRight) :
    UpperLeft(UpperLeft), LowerRight(LowerRight) {}

  Point<T> UpperLeft, LowerRight;
};

int main(int argc, char *argv[]) {
  // Create a new lua state
  lua_State *myLuaState = lua_open();

  // Connect LuaBind to this lua state
  luabind::open(myLuaState);

  // Export our classes with LuaBind
  luabind::module(myLuaState) [
    luabind::class_<Point<float> >("Point")
      .def(luabind::constructor<float, float>())
      .def_readwrite("X", &Point<float>::X)
      .def_readwrite("Y", &Point<float>::Y),

    luabind::class_<Box<float> >("Box")
      .def(luabind::constructor<Point<float>, Point<float> >())
      .def_readwrite("UpperLeft", &Box<float>::UpperLeft)
      .def_readwrite("LowerRight", &Box<float>::LowerRight)
  ];

  // Now use this class in a lua script
  luaL_dostring(
    myLuaState,
    "MyBox = Box(Point(10, 20), Point(30, 40))\n"
    "MyBox.UpperLeft.X = MyBox.LowerRight.Y\n"
  );

  lua_close(myLuaState);

  return 0;
}
