// http://www.nuclex.org/articles/quick-introduction-to-luabind

extern "C" {
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


void print_hello(int number) {
  std::cout << "hello world " << number << std::endl;
}


int main(int argc, char *argv[])
{
  // Create a new lua state
  lua_State *myLuaState = lua_open();

  // Connect LuaBind to this lua state
  luabind::open(myLuaState);

  // Add our function to the state's global scope
  luabind::module(myLuaState) [
    luabind::def("print_hello", print_hello)
  ];

  // Now call our function in a lua script
  luaL_dostring(
    myLuaState,
    "print_hello(123)\n"
  );

  lua_close(myLuaState);

  return 0;
}
