// http://www.nuclex.org/articles/quick-introduction-to-luabind

extern "C" {
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


class NumberPrinter {
  public:
    NumberPrinter(int number) :
      m_number(number) {}

    void print() {
      std::cout << m_number << std::endl;
    }

  private:
    int m_number;
};


int main(int argc, char *argv[])
{
  // Create a new lua state
  lua_State *myLuaState = lua_open();

  // Connect LuaBind to this lua state
  luabind::open(myLuaState);

  // Export our class with LuaBind
  luabind::module(myLuaState) [
    luabind::class_<NumberPrinter>("NumberPrinter")
      .def(luabind::constructor<int>())
      .def("print", &NumberPrinter::print)
  ];

  // Now use this class in a lua script
  luaL_dostring(
    myLuaState,
    "Print2000 = NumberPrinter(2000)\n"
    "Print2000:print()\n"
  );

  lua_close(myLuaState);

  return 0;
}
