// http://www.nuclex.org/articles/quick-introduction-to-luabind

extern "C" {
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


int main(int argc, char *argv[])
{
  // Create a new lua state
  lua_State *myLuaState = lua_open();

  // Connect LuaBind to this lua state
  luabind::open(myLuaState);

  // Define a lua function that we can call
  luaL_dostring(
    myLuaState,
    "function add(first, second)\n"
    "  return first + second\n"
    "end\n"
  );

  std::cout << "Result: "
            << luabind::call_function<int>(myLuaState, "add", 2, 3)
            << std::endl;

  lua_close(myLuaState);

  return 0;
}
