/*!
  \file
  \brief パラメータの読み出しサンプル

  \author Satofumi KAMIMURA

  $Id: readParameters.cpp 231 2008-09-23 08:17:00Z satofumi $
*/

extern "C"
{
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


struct person_t {
  int id;
  int age;
};

struct group_t {
  person_t pair_0;
  person_t pair_1;
};


int main(int argc, char *argv[])
{
  lua_State *lua = lua_open();
  luabind::open(lua);

  luabind::module(lua) [
    luabind::class_<group_t>("group_t")
      .def_readwrite("pair_0", &group_t::pair_0)
      .def_readwrite("pair_1", &group_t::pair_1),

    luabind::class_<person_t>("person_t")
      .def_readwrite("id", &person_t::id)
      .def_readwrite("age", &person_t::age)
  ];

  luaL_dostring(lua,
                "function initialize_person(group)\n"
                "group.pair_0.id = 100\n"
                "group.pair_1.id = 99\n"
                "end\n");

  group_t group;
  group.pair_0.id = 10;
  group.pair_0.age = 3;

  luabind::call_function<void>(lua, "initialize_person", boost::ref(group));

  std::cout << "id: " << group.pair_0.id << std::endl
            << "id: " << group.pair_1.id << std::endl
            << "age: " << group.pair_0.age << std::endl;

  lua_close(lua);

  return 0;
}
