/*!
  \file
  \brief イテレータの使用サンプル

  \author Satofumi KAMIMURA

  $Id: iterator_sample.cpp 231 2008-09-23 08:17:00Z satofumi $
*/

extern "C"
{
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <luabind/iterator_policy.hpp>
#include <iostream>
#include <vector>


struct X {
  std::vector<int> numbers;
};


int main(int argc, char *argv[])
{
  lua_State *lua = lua_open();
  luaL_openlibs(lua);
  luabind::open(lua);

  luabind::module(lua) [
    luabind::class_<X>("X")
      .def_readwrite("numbers", &X::numbers, luabind::return_stl_iterator)
  ];

  luaL_dostring(lua,
                "function square(data)\n"
                "  for number in data.numbers do\n"
                "    number = number * number\n"
                "    print(number)\n"
                "  end\n"
                "end\n");

  X data;
  for (int i = 0; i < 10; ++i) {
    data.numbers.push_back(i);
  }

  luabind::call_function<void>(lua, "square", boost::ref(data));

  for (std::vector<int>::iterator it = data.numbers.begin();
       it != data.numbers.end(); ++it) {
    std::cout << *it << ", ";
  }
  std::cout << std::endl;

  lua_close(lua);

  return 0;
}
