/*!
  \file
  \brief Luabind を用いて C++ 関数を lua に公開する例

  \author Satofumi KAMIMURA

  「実例で学ぶ ゲームAIプログラミング」より
*/

extern "C" {
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>


static void hello(const char* name) {
  printf("hello %s\n", name);
}


int main(int argc, char *argv[]) {

  // lua のスタックを作成
  lua_State* pLua = lua_open();

  // luabind を初期化
  luabind::open(pLua);

  // C++ 関数の登録
  luabind::module(pLua) [
    luabind::def("hello", &hello)
  ];

  // lua スクリプトの実行
  if (int error = luaL_dofile(pLua, "hello.lua") != 0) {
    printf("Error %d\n", error);
    exit(1);
  }

  // linbind の終了処理
  lua_close(pLua);

  return 0;
}

