/*!
  \file
  \brief 配列の操作サンプル

  \author Satofumi KAMIMURA

  $Id: array_rw.cpp 231 2008-09-23 08:17:00Z satofumi $
*/

extern "C"
{
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
}

#include <luabind/luabind.hpp>
#include <iostream>


struct sample_t {
  int* array;
  int data;
};


int main(int argc, char *argv[])
{
  lua_State *lua = lua_open();
  luabind::open(lua);

  luabind::module(lua) [
    luabind::class_<sample_t>("sample_t")
    .def_readwrite("data", &sample_t::data)
  ];

  luaL_dostring(lua,
                "function initialize_data(sample)\n"
                "sample.data = 100\n"
                "end\n");

  sample_t sample;
  sample.data = 10;

  luabind::call_function<void>(lua, "initialize_data", boost::ref(sample));

  std::cout << "id: " << sample.data << std::endl;

  lua_close(lua);

  return 0;
}
