/*!
  \file
  \brief 浮動小数点演算の計算時間のプロファイル

  \author Satofumi KAMIMURA

  $Id: floating_evaluate.cpp 163 2008-08-21 00:50:14Z satofumi $
*/

#include "GetTicks.h"
#include <stdio.h>
#include <math.h>

using namespace qrk;

#define ATAN2


int main(int argc, char *argv[])
{
  enum {
    TryTimes = 10000000,
  };

  for (int j = 0; j < 2; ++j) {
    volatile float float_result = 1.0;
    int first_ticks = getTicks();
    for (int i = 0; i < TryTimes; ++i) {
#ifdef ATAN2
      float_result = atan2(1.23 * i, 1.23) + float_result;
#else
      float_result /= 1.23f;
#endif
    }
    printf("float: %d [msec]\n", getTicks() - first_ticks);

    volatile double double_result = 1.0;
    first_ticks = getTicks();
    for (int i = 0; i < TryTimes; ++i) {
#ifdef ATAN2
      double_result = atan2(1.23 * i, 1.23) + double_result;
#else
      double_result /= 1.23;
#endif
    }
    printf("double: %d [msec]\n", getTicks() - first_ticks);
  }

  return 0;
}
