/*!
  \file
  \brief Wii 状態の表示

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include "WiiStateWidget.h"


int main(int argc, char *argv[]) {

  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("WiiState_" + locale);
  app.installTranslator(&translator);

  // アプリケーションの起動
  WiiStateWidget widget;
  widget.show();
  return app.exec();
}
