#ifndef WII_STATE_WIDGET_H
#define WII_STATE_WIDGET_H

/*!
  \file
  \brief Wii 状態の表示ウィジット

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_WiiStateWidgetForm.h"


/*!
  Wii 状態の表示ウィジット
*/
class WiiStateWidget : public QWidget, private Ui::WiiStateWidgetForm {
  Q_OBJECT;

  WiiStateWidget(const WiiStateWidget& rhs);
  WiiStateWidget& operator = (const WiiStateWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectionHandler(bool checked);
  void ledHandler(void);
  void rumbleHandler(void);
  void statusUpdate(void);

public:
  explicit WiiStateWidget(QWidget* parent = 0);
  ~WiiStateWidget(void);

  // !!!
};

#endif /* !WII_STATE_WIDGET_H */
