/*!
  \file
  \brief wii リモコン姿勢の OpenGL 表示

  \author Satofumi KAMIMURA

  $Id: WiiPoseDraw.cpp 130 2008-07-25 06:00:54Z satofumi $

  Qt 4.4 の「Textures」のコードを利用している

  \todo 最大化したときに、WiiPoseDraw も最大化されるようにする
*/

#include <QtGui>
#include <QtOpenGL>
#include "WiiPoseDraw.h"
#include "GridTypes.h"

using namespace qrk;


struct WiiPoseDraw::pImpl {

  GLuint object_;
  QColor clear_color_;
  Grid3D<int> rotate_;

  pImpl(void)
    : object_(0),
      clear_color_(Qt::black) {
  }

  void initializeGL(WiiPoseDraw* parent) {

    parent->qglClearColor(clear_color_);
    object_ = makeObject(parent);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);

    rotate_.z = 90;
  }

  void paintGL(WiiPoseDraw* parent) {

    parent->qglClearColor(clear_color_);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
    glRotated(rotate_.x, 1.0, 0.0, 0.0);
    glRotated(rotate_.y, 0.0, 1.0, 0.0);
    glRotated(rotate_.z, 0.0, 0.0, 1.0);
    glCallList(object_);
  }

  GLuint makeObject(WiiPoseDraw* parent) {

    static const int coords[6][4][3] = {
      { { +1, -1, -1 }, { -1, -1, -1 }, { -1, +1, -1 }, { +1, +1, -1 } },
      { { +1, +1, -1 }, { -1, +1, -1 }, { -1, +1, +1 }, { +1, +1, +1 } },
      { { +1, -1, +1 }, { +1, -1, -1 }, { +1, +1, -1 }, { +1, +1, +1 } },
      { { -1, -1, -1 }, { -1, -1, +1 }, { -1, +1, +1 }, { -1, +1, -1 } },
      { { +1, -1, +1 }, { -1, -1, +1 }, { -1, -1, -1 }, { +1, -1, -1 } },
      { { -1, -1, +1 }, { +1, -1, +1 }, { +1, +1, +1 }, { -1, +1, +1 } }
    };

    GLuint textures[6];
    for (int j = 0; j < 6; ++j) {
      textures[j] =
        parent->bindTexture(QPixmap(QString(":/images/texture%1").arg(j)),
                            GL_TEXTURE_2D);
    }

    GLuint list = glGenLists(1);
    glNewList(list, GL_COMPILE);
    for (int i = 0; i < 6; ++i) {
      glBindTexture(GL_TEXTURE_2D, textures[i]);
      glBegin(GL_QUADS);
      for (int j = 0; j < 4; ++j) {
        glTexCoord2d(((j == 0) || (j == 3)), ((j == 0) || (j == 1)));
        glVertex3d(0.2 * coords[i][j][0],
                   0.2 * coords[i][j][1],
                   0.85 * coords[i][j][2]);
      }
      glEnd();
    }

    glEndList();
    return list;
  }
};


WiiPoseDraw::WiiPoseDraw(QWidget* parent)
  : QGLWidget(parent), pimpl(new pImpl) {
}


WiiPoseDraw::~WiiPoseDraw(void) {
  makeCurrent();
}


void WiiPoseDraw::initializeGL(void) {
  pimpl->initializeGL(this);
}


QSize WiiPoseDraw::minimumSizeHint(void) const {
  return QSize(50, 50);
}


QSize WiiPoseDraw::sizeHint(void) const {
  return QSize(300, 300);
}


void WiiPoseDraw::resizeGL(int width, int height) {

  glViewport(0, 0, width, height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
  glMatrixMode(GL_MODELVIEW);
}


void WiiPoseDraw::paintGL(void) {
  pimpl->paintGL(this);
}


void WiiPoseDraw::rotate(int x, int y, int z) {

  pimpl->rotate_.x = x;
  pimpl->rotate_.y = y;
  pimpl->rotate_.z = z;

  updateGL();
}
