-- ３軸加速度から角度を計算するスクリプト
-- Satofumi KAMIMURA
-- $Id: calculateAngle.lua 276 2008-10-14 15:19:23Z satofumi $

local G = 9.80
local PI = 3.14159265358979323846

local pre_x_acc = 0.0;
local swing_counter = 0


function calculateAngle(t, x, y, z)
   --print(t, x, y, z)

   local x_acc = x * G
   local y_acc = y * G

   -- 素振り回数の計測
   -- x, y の点が y > G で X 軸を第３象限に移動したときに、加算する
   -- ただし、x_acc が 0 のときに２回加算するのを防ぐために、x_acc は 0 以外とする
   --print(t, y_acc, x_acc, pre_x_acc)
   if ((y_acc > (3 * G)) and (x_acc ~= 0)) then
      if ((x_acc * pre_x_acc <= 0) and (pre_x_acc > x_acc)) then
	 swing_counter = swing_counter + 1
	 print(swing_counter)
      end
   end

   -- 静止とみなしたときの、刀身の角度計算
   local static_angle = atan2(-y_acc, -x_acc)

   local return_angle = static_angle * 180.0 / PI
   --print(return_angle)

   pre_x_acc = x_acc

   return return_angle
end
