#ifndef XY_GRAPH_WIDGET_H
#define XY_GRAPH_WIDGET_H

/*!
  \file
  \brief 二次元データ表示

  \author Satofumi KAMIMURA

  $Id: XyGraphWidget.h 239 2008-09-26 21:35:40Z satofumi $
*/

#include <QGLWidget>


class XyGraphWidget : public QGLWidget
{
  XyGraphWidget(const XyGraphWidget& rhs);
  XyGraphWidget& operator = (const XyGraphWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);

public:
  XyGraphWidget(QWidget* parent = 0);
  ~XyGraphWidget(void);

  void clear(void);
  void redraw(void);
  void setDrawPeriod(int msec);

  void setData(int timestamp, double x, double y);
};

#endif /* !XY_GRAPH_WIDGET_H */
