#ifndef WII_BLADE_WINDOW_H
#define WII_BLADE_WINDOW_H

/*!
  \file
  \brief Wii ブレード用のウィンドウ管理

  \author Satofumi KAMIMURA

  $Id: WiiBladeWindow.h 240 2008-09-26 23:49:27Z satofumi $
*/

#include "ui_WiiBladeWindowForm.h"


class WiiBladeWindow : public QMainWindow, private Ui::WiiBladeWindowForm
{
  Q_OBJECT;

  WiiBladeWindow(const WiiBladeWindow& rhs);
  WiiBladeWindow& operator = (const WiiBladeWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void aboutApplication(void);
  void rescanPressed(void);
  void connectPressed(void);
  void disconnectPressed(void);
  void recordData(void);
  void playPressed(void);
  void repeatPressed(bool checked);
  void updatePlayData(void);

public:
  WiiBladeWindow(void);
  ~WiiBladeWindow(void);
};

#endif /* !WII_BLADE_WINDOW_H */
