#ifndef TIME_GRAPH_WIDGET_H
#define TIME_GRAPH_WIDGET_H

/*!
  \file
  \brief 時刻データ表示

  \author Satofumi KAMIMURA

  $Id: TimeGraphWidget.h 240 2008-09-26 23:49:27Z satofumi $
*/

#include <QGLWidget>


class TimeGraphWidget : public QGLWidget
{
  TimeGraphWidget(const TimeGraphWidget& rhs);
  TimeGraphWidget& operator = (const TimeGraphWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);

public:
  TimeGraphWidget(QWidget* parent = 0);
  ~TimeGraphWidget(void);

  void clear(void);
  void redraw(void);
  void setDrawPeriod(int msec);

  void setDataColor(int index, Qt::GlobalColor color);
  void setTime(int timestamp);
  void setData(int index, double value);
};

#endif /* !TIME_GRAPH_WIDGET_H */
