#ifndef SWING_IMAGE_WIDGET_H
#define SWING_IMAGE_WIDGET_H

/*!
  \file
  \brief 素振りのイメージ描画

  \author Satofumi KAMIMURA

  $Id: SwingImageWidget.h 239 2008-09-26 21:35:40Z satofumi $
*/

#include <QGLWidget>

namespace qrk
{
  class Angle;
};


class SwingImageWidget : public QGLWidget
{
  SwingImageWidget(const SwingImageWidget& rhs);
  SwingImageWidget& operator = (const SwingImageWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);

public:
  SwingImageWidget(QWidget* parent = 0);
  ~SwingImageWidget(void);

  void clear(void);
  void setBladeAngle(const qrk::Angle& angle);
  // !!!
};

#endif /* !SWING_IMAGE_WIDGET_H */
