/*!
  \file
  \brief URG ポートの表示

  \author Satofumi KAMIMURA

  $Id: ViewUrgPortsWidget.cpp 179 2008-08-28 00:10:05Z satofumi $
*/

#include "ViewUrgPortsWidget.h"
#include "UrgUsbCom.h"
#include "FindComPorts.h"
#include <QShortcut>

using namespace qrk;


struct ViewUrgPortsWidget::pImpl {


  void initializeForm(ViewUrgPortsWidget* parent) {

    // シグナルの接続
    connect(parent->rescan_button_, SIGNAL(clicked()),
            parent, SLOT(rescanHandler()));
  }


  void rescanPorts(ViewUrgPortsWidget* parent) {

    UrgUsbCom urg_usb;
    FindComPorts urg_finder(&urg_usb);
    std::vector<std::string> urg_ports = urg_finder.find();

    parent->ports_list_widget_->clear();

    for (std::vector<std::string>::iterator it = urg_ports.begin();
         it != urg_ports.end(); ++it) {
      std::string view_name = *it
        + (urg_usb.isUsbCom(it->c_str()) ? " [URG]" : "");

      parent->ports_list_widget_->addItem(view_name.c_str());
    }
  }
};


ViewUrgPortsWidget::ViewUrgPortsWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl) {
  setupUi(this);

  // フォームを初期化し、最初の表示を行う
  pimpl->initializeForm(this);
  pimpl->rescanPorts(this);

  // Ctrl-q で終了させる
  (void) new QShortcut(Qt::CTRL + Qt::Key_Q, this, SLOT(close()));
}


ViewUrgPortsWidget::~ViewUrgPortsWidget(void) {
}


void ViewUrgPortsWidget::rescanHandler(void) {

  pimpl->rescanPorts(this);
}
