/*!
  \file
  \brief Wii を用いた URG データの三次元描画

  \author Satofumi KAMIMURA

  $Id: UrgScanner.cpp 199 2008-09-02 10:55:59Z satofumi $
*/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include "UrgScannerWindow.h"


//! main
int main(int argc, char *argv[]) {

  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("UrgScanner_" + locale);
  app.installTranslator(&translator);

  // アプリケーションの起動
  UrgScannerWindow window;
  window.show();
  return app.exec();
}
