/*!
  \file
  \brief URG を振って 3D データの取得を行うデモアプリ

  \author Satofumi KAMIMURA

  $Id: main.cpp 280 2008-10-17 04:43:23Z satofumi $
*/

#include "SwingScan3DWindow.h"
#include "LuaHandler.h"
#include "initializeLuaBind.h"
#include <QApplication>
#include <QTranslator>

using namespace qrk;


int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("SwingScan3D_" + locale);
  app.installTranslator(&translator);

  // スクリプトの初期化
  LuaHandler* lua = LuaHandler::singleton();
  initializeLuaBind(lua->luaPointer());

  SwingScan3DWindow window;
  window.show();
  return app.exec();
}
