/*!
  \file
  \brief LuaBind 設定の初期化

  \author Satofumi KAMIMURA

  $Id: initializeLuaBind.cpp 176 2008-08-27 07:52:06Z satofumi $
*/

#include "initializeLuaBind.h"
#include <luabind/luabind.hpp>


int Ticks = 0;
int ViewX = 0;
int ViewY = 0;
int ViewZ = 0;


void SetX(int x)
{
  ViewX = x;
}


void SetY(int y)
{
  ViewY = y;
}


void SetZ(int z)
{
  ViewZ = z;
}


int GetT(void)
{
  return Ticks;
}


void initializeLuaBind(lua_State* lua)
 {
  // luabind を初期化
  luabind::open(lua);

  // C++ 関数の登録
  luabind::module(lua) [
    luabind::def("setX", &SetX),
    luabind::def("setY", &SetY),
    luabind::def("setZ", &SetZ),
    luabind::def("getT", &GetT)
  ];
}
