#ifndef CONVERT_2D_WITH_INTENSITY_H
#define CONVERT_2D_WITH_INTENSITY_H

/*!
  \file
  \brief 強度データも含めて 2D 変換を行う

  \author Satofumi KAMIMURA

  $Id: convert2DWithIntensity.h 185 2008-08-29 02:10:51Z satofumi $
*/

#include "GridTypes.h"
#include <vector>


namespace qrk
{
  class RangeSensor;
};

void convert2DWithIntensity(std::vector<qrk::Grid<int> >& length_points,
                            std::vector<int>& intensity_points,
                            const qrk::RangeSensor* sensor,
                            const long* length_data, size_t size,
                            const long* intensity_data,
                            int min_distance, int max_distance,
                            const qrk::Grid<int>* offset = NULL);

#endif /* !CONVERT_2D_WITH_INTENSITY_H */
