/*!
  \file
  \brief 強度データも含めて 2D 変換を行う

  \author Satofumi KAMIMURA

  $Id: convert2DWithIntensity.cpp 185 2008-08-29 02:10:51Z satofumi $
*/

#include "convert2DWithIntensity.h"
#include "RangeSensor.h"
#include "MathUtils.h"

using namespace qrk;


void convert2DWithIntensity(std::vector<qrk::Grid<int> >& length_points,
                            std::vector<int>& intensity_points,
                            const RangeSensor* sensor,
                            const long* length_data, size_t size,
                            const long* intensity_data,
                            int min_distance, int max_distance,
                            const qrk::Grid<int>* offset)
{
  Grid<int> additional_offset = (offset) ? *offset : Grid<int>(0, 0);

  for (size_t i = 0; i < size; ++i) {
    long distance = length_data[i];
    if ((distance <= min_distance) || (distance >= max_distance)) {
      continue;
    }

    double radian = sensor->index2rad(i);
    int x = static_cast<int>(distance * cos(radian)) + additional_offset.x;
    int y = static_cast<int>(distance * sin(radian)) + additional_offset.y;

    Grid<int> length_point(x, y);
    length_points.push_back(length_point);

    intensity_points.push_back(intensity_data[i]);
  }
}
