#ifndef SWING_THREAD_H
#define SWING_THREAD_H

/*!
  \file
  \brief モータの動作スレッド

  \author Satofumi KAMIMURA

  $Id: SwingThread.h 253 2008-10-02 06:42:39Z satofumi $
*/

#include <QThread>

class DensanMotor;

namespace qrk
{
  class Angle;
};


class SwingThread : public QThread
{
  SwingThread(void);
  SwingThread(const SwingThread& rhs);
  SwingThread& operator = (const SwingThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  typedef enum {
    Initializing,
    CW,
    CCW,
  } SwingState;

  explicit SwingThread(DensanMotor* motor);
  ~SwingThread(void);

  qrk::Angle swingRange(void);
  void setSwingRange(const qrk::Angle& angle);

  void run(void);
  int counter(void);
  SwingState state(void);

  void stop(void);
};

#endif /* !SWING_THREAD_H */
