#ifndef SWING_SCAN_3D_WINDOW_H
#define SWING_SCAN_3D_WINDOW_H

/*!
  \file
  \brief メインウィンドウ

  操作 GUI と、２画面のデータ表示ウィジットを管理する

  \author Satofumi KAMIMURA

  $Id: SwingScan3DWindow.h 251 2008-10-02 05:32:44Z satofumi $
*/

#include "ui_SwingScan3DWindowForm.h"
#include <QMainWindow>


class SwingScan3DWindow : public QMainWindow, private Ui::SwingScan3DWindowForm
{
  Q_OBJECT;

  SwingScan3DWindow(const SwingScan3DWindow& rhs);
  SwingScan3DWindow& operator = (const SwingScan3DWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rescan(void);
  void urgSelected(void);
  void motorSelected(void);
  void connectSensors(void);
  void disconnectSensors(void);
  void capture(void);

  void redraw(void);

  void config(void);
  void swingRange(int degree);
  void swingOffset(int degree);
  void ignoreLength(int mm);

  void initializePositionOrder(void);
  void save(void);

public:
  SwingScan3DWindow(void);
  ~SwingScan3DWindow(void);
};

#endif /* !SWING_SCAN_3D_WINDOW_H */
