#ifndef SCANED_CONTROL_WIDGET_H
#define SCANED_CONTROL_WIDGET_H

/*!
  \file
  \brief {^t̕`EBWbg

  \author Satofumi KAMIMURA

  $Id: ScanedControlWidget.h 246 2008-09-30 11:39:48Z satofumi $
*/

#include "Points3D.h"
#include "ui_ScanedControlWidgetForm.h"
#include <QWidget>


class ScanedControlWidget : public QWidget, private Ui::ScanedControlWidgetForm
{
  Q_OBJECT;

  ScanedControlWidget(const ScanedControlWidget& rhs);
  ScanedControlWidget& operator = (const ScanedControlWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rotateLeft(void);
  void rotateRight(void);
  void rotateUp(void);
  void rotateDown(void);

  void moveLeft(void);
  void moveRight(void);
  void moveUp(void);
  void moveDown(void);

  void autoButton(bool checked);

public slots:
  void setZoomPercent(int value);

public:
  ScanedControlWidget(QWidget* parent = 0);
  ~ScanedControlWidget(void);

  PointsLine& emptyLine(void);
  void updateCameraView(void);
  void redraw(Points3D* data, Intensity3D* intensity_data, bool isUpdating);

  int zoomPercent(void);

  void save(const char* fname);
};

#endif /* !SCANED_CONTROL_WIDGET_H */
