#ifndef DATA_DRAW_WIDGET_H
#define DATA_DRAW_WIDGET_H

/*!
  \file
  \brief データ描画ウィジット

  \author Satofumi KAMIMURA

  $Id: DataDrawWidget.h 246 2008-09-30 11:39:48Z satofumi $
*/

#include "Points3D.h"
#include <QGLWidget>


class DataDrawWidget : public QGLWidget {
  Q_OBJECT;

  DataDrawWidget(const DataDrawWidget& rhs);
  DataDrawWidget& operator = (const DataDrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);

public:
  DataDrawWidget(QGLWidget* parent = 0);
  ~DataDrawWidget(void);

  PointsLine& emptyLine(void);
  void redraw(Points3D* data, Intensity3D* intensity_data, bool isUpdating);

  void setZoomRatio(const double ratio);
  void zoomIn(void);
  void zoomOut(void);
  double zoomRatio(void);

  qrk::Grid3D<int> rotation(void);
  void setRotation(const qrk::Grid3D<int>& rotation);
  void rotateLeft(void);
  void rotateRight(void);
  void rotateUp(void);
  void rotateDown(void);

  qrk::Grid3D<int> position(void);
  void moveLeft(void);
  void moveRight(void);
  void moveUp(void);
  void moveDown(void);

  void save(const char* fname);
};

#endif /* !DATA_DRAW_WIDGET_H */
