#ifndef CONFIG_DIALOG_H
#define CONFIG_DIALOG_H

/*!
  \file
  \breif 設定フォーム

  \author Satofumi KAMIMURA

  $Id: ConfigDialog.h 251 2008-10-02 05:32:44Z satofumi $
*/

#include "ui_ConfigDialogForm.h"


namespace qrk
{
  class Angle;
};


class ConfigDialog : public QDialog, private Ui::ConfigDialogForm
{
  Q_OBJECT;

  ConfigDialog(const ConfigDialog& rhs);
  ConfigDialog& operator = (const ConfigDialog& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void swingRange(int degree);
  void swingOffset(int degree);
  void ignoreLength(int mm);
  void initializePosition(void);

public:
  ConfigDialog(QWidget* parent = 0);
  ~ConfigDialog(void);

  void setSwingRange(const qrk::Angle& angle);
  void setSwingOffset(const qrk::Angle& angle);
  void setIgnoreLength(int mm);

signals:
  void swingRangeChanged(int degree);
  void swingOffsetChanged(int degree);
  void ignoreLengthChanged(int mm);
  void initializePositionOrder(void);
};

#endif /* !CONFIG_DIALOG_H */
