/*!
  \file
  \breif 設定フォーム

  \author Satofumi KAMIMURA

  $Id: ConfigDialog.cpp 251 2008-10-02 05:32:44Z satofumi $

  \todo URG の初期位置の角度を、設定できるようにする
  \todo モータの回転速度を、変更できるようにする
*/

#include "ConfigDialog.h"
#include "AngleTypes.h"

using namespace qrk;


struct ConfigDialog::pImpl
{
  ConfigDialog* parent_;


  pImpl(ConfigDialog* parent) : parent_(parent)
  {
  }


  void initializeForm(void)
  {
    connect(parent_->swing_range_spinbox_, SIGNAL(valueChanged(int)),
            parent_, SLOT(swingRange(int)));
    connect(parent_->swing_offset_spinbox_, SIGNAL(valueChanged(int)),
            parent_, SLOT(swingOffset(int)));
    connect(parent_->ignore_length_spinbox_, SIGNAL(valueChanged(int)),
            parent_, SLOT(ignoreLength(int)));
    connect(parent_->initialize_position_button_, SIGNAL(clicked()),
	    parent_, SLOT(initializePosition()));
  }
};


ConfigDialog::ConfigDialog(QWidget* parent)
  : QDialog(parent), pimpl(new pImpl(this))
{
  setupUi(this);

  pimpl->initializeForm();
}


ConfigDialog::~ConfigDialog(void)
{
}


void ConfigDialog::swingRange(int degree)
{
  emit swingRangeChanged(degree);
}


void ConfigDialog::swingOffset(int degree)
{
  emit swingOffsetChanged(degree);
}


void ConfigDialog::ignoreLength(int mm)
{
  emit ignoreLengthChanged(mm);
}


void ConfigDialog::setSwingRange(const Angle& angle)
{
  swing_range_spinbox_->setValue(angle.to_deg());
}


void ConfigDialog::setSwingOffset(const Angle& angle)
{
  swing_offset_spinbox_->setValue(angle.to_deg());

}


void ConfigDialog::setIgnoreLength(int mm)
{
  ignore_length_spinbox_->setValue(mm);
}


void ConfigDialog::initializePosition(void)
{
  emit initializePositionOrder();
}
