-- 素振り回数を計測する
-- Satofumi KAMIMURA
-- $Id: swing_count.lua 276 2008-10-14 15:19:23Z satofumi $

-- \todo 下の方を向けているときに、カウントが増加するのを修正する
-- \todo 素振りを途中に一旦停止したときに、２回のカウントになるのを修正する


local G = 9.80
local PI = 3.14159265358979323846

local swing_times_ = 0


-- 素振り回数の初期化
function clear_swings()
   swing_times_ = 0
end


-- 現在の素振り回数を返す
local pre_x_acc = 0.0;
function swing_count(t, x, y, z, sw)

   local x_acc = x * G
   local y_acc = y * G

   -- 素振り回数の計測
   -- x, y の点が y > G で X 軸を第３象限に移動したときに、加算する
   -- ただし、x_acc が 0 のときに２回加算するのを防ぐため、x_acc は 0 以外とする
   if ((y_acc > (3 * G)) and (x_acc ~= 0)) then
      if ((x_acc * pre_x_acc <= 0) and (pre_x_acc > x_acc)) then
	 swing_times_ = swing_times_ + 1

	 -- 10 回毎に、Wii リモコンを振動させる
	 if ((swing_times_ % 10) == 0) then
	    sw:rumble(500)
	 end
      end
   end
   pre_x_acc = x_acc

   -- 現在の素振り回数を返す
   return swing_times_
end
