#ifndef LUA_BIND_INITIALIZE_H
#define LUA_BIND_INITIALIZE_H

/*!
  \file
  \brief LuaBind 用の初期化処理

  \author Satofumi KAMIMURA

  $Id: initializeLuaBind.h 290 2008-10-22 15:35:54Z satofumi $
*/

#include "GridTypes.h"
extern "C"
{
#include <lua.h>
}

class SwingCounterWidget;


extern void initializeLuaBind(lua_State* lua, const char* lua_path);

extern void lua_clearSwingTimes(lua_State* lua);
extern int lua_swingTimes(lua_State* lua,
                          int ticks, const qrk::Grid3D<double>& acc,
                          SwingCounterWidget* sw);

#endif /* !LUA_BIND_INITIALIZE_H */
