/*!
  \file
  \brief LuaBind 用の初期化処理

  \author Satofumi KAMIMURA

  $Id: initializeLuaBind.cpp 290 2008-10-22 15:35:54Z satofumi $
*/

#include "initializeLuaBind.h"
#include "SwingCounterWidget.h"
extern "C"
{
#include <lualib.h>
#include <lauxlib.h>
}
#include <luabind/luabind.hpp>
#include <cmath>


void initializeLuaBind(lua_State* lua, const char* lua_path)
{
  luabind::open(lua);

  luabind::module(lua) [
    luabind::def("sin", &sin),
    luabind::def("cos", &cos),
    luabind::def("atan2", &atan2),
    luabind::def("sqrt", &sqrt),

    luabind::class_<SwingCounterWidget>("SwingCounterWidget")
      .def("rumble", &SwingCounterWidget::rumble)
  ];

  std::string path = std::string(lua_path) + "/swing_count.lua";
  if (luaL_dofile(lua, path.c_str()) != 0) {
    printf("error: %s\n", lua_tostring(lua, -1));
  }
}


void lua_clearSwingTimes(lua_State* lua)
{
  luabind::call_function<void>(lua, "clear_swings");
}


int lua_swingTimes(lua_State* lua,
                   int ticks, const qrk::Grid3D<double>& acc,
                   SwingCounterWidget* sw)
{
  int swing_times = luabind::call_function<int>(lua, "swing_count",
                                                ticks,
                                                acc.x, acc.y, acc.z,
                                                sw);
  return swing_times;
}
