#ifndef WIIMOTE_CONNECT_THREAD_H
#define WIIMOTE_CONNECT_THREAD_H

/*!
  \file
  \brief Wiimote への接続処理スレッド

  \author Satofumi KAMIMURA

  $Id: WiimoteConnectThread.h 289 2008-10-21 22:39:04Z satofumi $
*/

#include <QThread>

namespace qrk
{
  class WiiJoystick;
};


class WiimoteConnectThread : public QThread
{
  Q_OBJECT;

  WiimoteConnectThread(const WiimoteConnectThread& rhs);
  WiimoteConnectThread& operator = (const WiimoteConnectThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void run(void);

public:
  WiimoteConnectThread(void);
  ~WiimoteConnectThread(void);

  void setWiimote(qrk::WiiJoystick* wii);

signals:
  void wiimoteConnected(void);
};

#endif /* !WIIMOTE_CONNECT_THREAD_H */
