/*!
  \file
  \brief Wiimote への接続処理スレッド

  \author Satofumi KAMIMURA

  $Id: WiimoteConnectThread.cpp 290 2008-10-22 15:35:54Z satofumi $
*/

#include "WiimoteConnectThread.h"
#include "WiiJoystick.h"

using namespace qrk;


struct WiimoteConnectThread::pImpl
{
  WiiJoystick* wii_;


  pImpl(void) : wii_(NULL)
  {
  }
};


WiimoteConnectThread::WiimoteConnectThread(void) : pimpl(new pImpl)
{
}


WiimoteConnectThread::~WiimoteConnectThread(void)
{
}


void WiimoteConnectThread::setWiimote(qrk::WiiJoystick* wii)
{
  pimpl->wii_ = wii;
}


void WiimoteConnectThread::run(void)
{
  while (true) {

    // !!! 再スキャンの処理

    if (pimpl->wii_->connect()) {
      break;
    }
    // 接続できなければ、しばらくしてから再度接続する
    sleep(1);
  }

  emit wiimoteConnected();
}
