#ifndef SWING_COUNTER_WIDGET_H
#define SWING_COUNTER_WIDGET_H

/*!
  \file
  \brief 素振り回数の表示 Widget

  \aurthor Satofumi KAMIMURA

  $Id: SwingCounterWidget.h 290 2008-10-22 15:35:54Z satofumi $
*/

#include "ui_SwingCounterWidgetForm.h"


class SwingCounterWidget : public QWidget, private Ui::SwingCounterWidgetForm
{
  Q_OBJECT;

  SwingCounterWidget(const SwingCounterWidget& rhs);
  SwingCounterWidget& operator = (const SwingCounterWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectWiimote(void);
  void captureAccelerations(void);
  void stopRumble(void);
  void configHandler(void);
  void wiimoteConnected(void);
  void closeEvent(QCloseEvent* event);
  void logDirectoryChanged(const std::string& path);

public:
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);

public:
  SwingCounterWidget(QWidget* parent = 0);
  ~SwingCounterWidget(void);

  void rumble(int rumble_msec);
};

#endif /* !SWING_COUNTER_WIDGET_H */
