#ifndef SETTING_WIDGET_H
#define SETTING_WIDGET_H

/*!
  \file
  \brief 設定管理

  \author Satofumi KAMIMURA

  $Id: SettingWidget.h 290 2008-10-22 15:35:54Z satofumi $
*/

#include "ui_SettingWidgetForm.h"


class SettingWidget : public QWidget, private Ui::SettingWidgetForm
{
  Q_OBJECT;

  SettingWidget(const SettingWidget& rhs);
  SettingWidget& operator = (const SettingWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void okPressed(void);
  void cancelPressed(void);
  void pathPressed(void);

public:
  SettingWidget(QWidget* parent = 0);
  ~SettingWidget(void);

  void setLogDirectory(const std::string& path);

signals:
  void logDirectoryChanged(const std::string& changed_path);
};

#endif /* !SETTING_WIDGET_H */
