/*!
  \file
  \brief 設定管理

  \author Satofumi KAMIMURA

  $Id: SettingWidget.cpp 290 2008-10-22 15:35:54Z satofumi $
*/

#include "SettingWidget.h"
#include "ConvertStdStringPath.h"
#include <QFileDialog>


struct SettingWidget::pImpl
{
  SettingWidget* parent_;
  QString original_path_;


  pImpl(SettingWidget* parent) : parent_(parent)
  {
  }


  void initializeForm(void)
  {
    connect(parent_->ok_button_, SIGNAL(clicked()),
            parent_, SLOT(okPressed()));
    connect(parent_->cancel_button_, SIGNAL(clicked()),
            parent_, SLOT(cancelPressed()));
    connect(parent_->path_button_, SIGNAL(clicked()),
            parent_, SLOT(pathPressed()));
  }
};


SettingWidget::SettingWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);
  pimpl->initializeForm();
}


SettingWidget::~SettingWidget(void)
{
}


void SettingWidget::okPressed(void)
{
  // 更新内容を反映
  std::string current_path = qrk::toStdStringPath(path_edit_->text());

  if (current_path.compare(pimpl->original_path_.toStdString())) {
    emit logDirectoryChanged(current_path);
  }
  close();
}


void SettingWidget::cancelPressed(void)
{
  close();
}


void SettingWidget::pathPressed(void)
{
  QString directory_name =
    QFileDialog::getExistingDirectory(this, tr("Swing Log Directory"),
                                      pimpl->original_path_);

  if (! directory_name.isEmpty()) {
    path_edit_->setText(directory_name);
  }
}


void SettingWidget::setLogDirectory(const std::string& path)
{
  pimpl->original_path_ = path.c_str();
  path_edit_->setText(path.c_str());
}
