#ifndef SCIP_PLOT_WINDOW_H
#define SCIP_PLOT_WINDOW_H

/*!
  \file
  \brief ScipPlot のウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_ScipPlotWindowForm.h"


/*!
  \brief ScipPlot のウィンドウ管理
*/
class ScipPlotWindow : public QMainWindow, private Ui::ScipPlotWindowForm {
  Q_OBJECT;

  ScipPlotWindow(const ScipPlotWindow& rhs);
  ScipPlotWindow& operator = (const ScipPlotWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectHandler(bool checked);

protected:
  //! 終了処理
  void closeEvent(QCloseEvent* event);

public:
  ScipPlotWindow(void);
  ~ScipPlotWindow(void);
};

#endif /* !SCIP_PLOT_WINDOW_H */
