/*!
  \file
  \brief ScipPlot のウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QCloseEvent>
#include "ScipPlotWindow.h"
#include "ScipPlotWidget.h"
#include "UrgCtrl.h"

using namespace qrk;


struct ScipPlotWindow::pImpl {

  UrgCtrl urg_;
  ScipPlotWidget plot_widget_;
  bool is_connected_;
  std::string device_;


  pImpl(void) : is_connected_(false) {
  }


  // フォームの初期化
  void initializeForm(ScipPlotWindow* parent) {

    QSizePolicy expanding_policy(QSizePolicy::Expanding,
                                 QSizePolicy::Expanding);
    plot_widget_.setSizePolicy(expanding_policy);
    parent->main_layout_->addWidget(&plot_widget_);

    // イベントの接続
    connect(parent->action_quit_, SIGNAL(triggered()), parent, SLOT(close()));
    connect(parent->connect_button_, SIGNAL(clicked(bool)),
            parent, SLOT(connectHandler(bool)));
  }


  // 接続 / 切断 の処理
  void connectHandler(ScipPlotWindow* parent) {

    if (! is_connected_) {
      // 接続
      if (! urg_.connect(device_.c_str())) {
        // !!! エラーメッセージを表示すべき
        // !!! QMessageBox などでを使う
        fprintf(stderr, "fail.\n");

        parent->connect_button_->setChecked(false);
        return;
      }
      is_connected_ = true;
      parent->connect_button_->setText(tr("Disconnect"));

    } else {
      // 切断
      urg_.disconnect();
      is_connected_ = false;
      parent->connect_button_->setText(tr("Connect"));
    }
  }
};


ScipPlotWindow::ScipPlotWindow(void) : pimpl(new pImpl) {
  setupUi(this);

  // フォームの初期化
  pimpl->initializeForm(this);
}


ScipPlotWindow::~ScipPlotWindow(void) {
}


void ScipPlotWindow::closeEvent(QCloseEvent* event) {

  // !!! Qt 本の P66 のあたりを参考のこと

  // !!! とりあえず、終了
  event->accept();
}


// 接続 / 切断 の処理
void ScipPlotWindow::connectHandler(bool checked) {
  static_cast<void>(checked);

  pimpl->connectHandler(this);
}
