#ifndef SCIP_PLOT_WIDGET_H
#define SCIP_PLOT_WIDGET_H

/*!
  \file
  \brief SCIP データの表示ウィジット

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QGLWidget>


/*!
  \brief SCIP データの表示ウィジット
*/
class ScipPlotWidget : public QGLWidget {
  Q_OBJECT;

  ScipPlotWidget(const ScipPlotWidget& rhs);
  ScipPlotWidget& operator = (const ScipPlotWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:

  //! OpenGL の初期化
  void initializeGL(void);

  //! リサイズ処理
  void resizeGL(int width, int height);

  /*!
    \brief 再描画
  */
  void paintGL(void);

  //! マウスの押下処理
  void mousePressEvent(QMouseEvent *event);

  //! マウスの移動処理
  void mouseMoveEvent(QMouseEvent *event);

  //! ホイールイベント処理
  void wheelEvent(QWheelEvent* event);

public:
  ScipPlotWidget(void);
  ~ScipPlotWidget(void);

  /*!
    \brief 再描画

    \param[in] points 描画データ
  */
  void redraw(const QVector<QPoint>& points);
};

#endif /* !SCIP_PLOT_WIDGET_H */
