/*!
  \file
  \brief SCIP データの表示ウィジット

  \author Satofumi KAMIMURA

  $Id$

  ハードウェアアクセラレーションを期待して、OpenGL を用いる
*/

#include "ScipPlotWidget.h"


namespace {
  typedef QVector<QPoint> Points;
};


struct ScipPlotWidget::pImpl {

  Points draw_points_;
  QColor clear_color_;


  pImpl(void) : clear_color_(Qt::black) {
  }


  void initializeGL(ScipPlotWidget* parent) {

    parent->qglClearColor(clear_color_);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glEnable(GL_TEXTURE_2D);
  }


#if 0
  void resizeGL(int width, int height) {
    static_cast<void>(width);
    static_cast<void>(height);

    // !!!
  }
#endif


  // 再描画
  void paintGL(void) {

    // グリッドの描画
    // !!!

    // 点の描画
    for (Points::iterator it = draw_points_.begin();
         it != draw_points_.end(); ++it) {
      // !!!
    }
  }
};


ScipPlotWidget::ScipPlotWidget(void) : pimpl(new pImpl) {

  // !!!
}


ScipPlotWidget::~ScipPlotWidget(void) {
}


void ScipPlotWidget::initializeGL(void) {

  pimpl->initializeGL(this);
}


void ScipPlotWidget::resizeGL(int width, int height) {
  static_cast<void>(width);
  static_cast<void>(height);

  // !!!
}


void ScipPlotWidget::paintGL(void) {

  // !!!
  pimpl->paintGL();
}


void ScipPlotWidget::mousePressEvent(QMouseEvent *event) {
  static_cast<void>(event);

  // !!!
}


void ScipPlotWidget::mouseMoveEvent(QMouseEvent *event) {
  static_cast<void>(event);

  // !!!
}


void ScipPlotWidget::wheelEvent(QWheelEvent* event) {
  static_cast<void>(event);

  // !!!
}


// 再描画
void ScipPlotWidget::redraw(const QVector<QPoint>& points) {

  pimpl->draw_points_ = points;
  update();
}
