#ifndef SCIP_DATA_READER_H
#define SCIP_DATA_READER_H

/*!
  \file
  \brief SCIP データを応答単位で読み出す

  \author Satofumi KAMIMURA

  $Id: ScipDataReader.h 299 2008-10-26 12:15:43Z satofumi $
*/

#include <vector>
#include <string>


class ScipDataReader
{
  ScipDataReader(const ScipDataReader& rhs);
  ScipDataReader& operator = (const ScipDataReader& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  ScipDataReader(const std::string& log_file);
  ~ScipDataReader(void);

  bool isEmpty(void);
  bool readReplyLines(std::vector<std::string>& line_block);
};

#endif /* !SCIP_DATA_READER_H */
