/*!
  \file
  \brief SCIP データを応答単位で読み出す

  \author Satofumi KAMIMURA

  $Id: ScipDataReader.cpp 300 2008-10-26 12:42:27Z satofumi $
*/

#include "ScipDataReader.h"
#include <fstream>


struct ScipDataReader::pImpl
{
  std::string log_file_;
  std::ifstream fin_;


  pImpl(const std::string& log_file) : log_file_(log_file)
  {
    fin_.open(log_file_.c_str());
  }
};


ScipDataReader::ScipDataReader(const std::string& log_file)
  : pimpl(new pImpl(log_file))
{
}


ScipDataReader::~ScipDataReader(void)
{
}


bool ScipDataReader::isEmpty(void)
{
  if (! pimpl->fin_.is_open()) {
    return true;
  }
  return (pimpl->fin_.eof()) ? true : false;
}


bool ScipDataReader::readReplyLines(std::vector<std::string>& line_block)
{
  line_block.clear();
  std::string line;
  while (getline(pimpl->fin_, line) && (! line.empty())) {
    line_block.push_back(line);
  }

  return (! line_block.empty());
}
