/*!
  \file
  \brief ScipAnalyzer メインウィンドウ管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QSplitter>
#include <QLabel>
#include "ScipAnalyzerWindow.h"


struct ScipAnalyzerWindow::pImpl {

  QSplitter* top_splitter_;
  QSplitter* main_splitter_;

  pImpl(ScipAnalyzerWindow* parent)
    : top_splitter_(new QSplitter(Qt::Horizontal, parent)),
      main_splitter_(new QSplitter(Qt::Vertical, parent)) {

    // スプリッターの設定
    top_splitter_->addWidget(new QLabel("left", parent));
    top_splitter_->addWidget(new QLabel("right", parent));
    //top_splitter_->setStretchFactor(1, 1);

    main_splitter_->addWidget(top_splitter_);
    main_splitter_->addWidget(new QLabel("bottom", parent));
    //main_splitter_->setStretchFactor(1, 1);

    parent->setCentralWidget(main_splitter_);
  }

  // フォームの初期化
  void initializeForm(ScipAnalyzerWindow* parent) {
    static_cast<void>(parent);

    // 前回実行と同じ場所、同じサイズで描画する
    // !!!

    // !!!
  }
};


ScipAnalyzerWindow::ScipAnalyzerWindow(void)
  : QMainWindow(), pimpl(new pImpl(this)) {

  // フォームの初期化
  pimpl->initializeForm(this);

  // !!!
}


ScipAnalyzerWindow::~ScipAnalyzerWindow(void) {
}
