#ifndef RECORD_THREAD_H
#define RECORD_THREAD_H

/*!
  \file
  \brief ログデータの記録スレッド

  \author Satofumi KAMIMURA

  $Id: RecordThread.h 201 2008-09-03 00:52:44Z satofumi $
*/

#include <QThread>

namespace qrk
{
  class Connection;
};


class RecordThread : public QThread
{
  RecordThread(void);
  RecordThread(const RecordThread& rhs);
  RecordThread& operator = (const RecordThread& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  explicit RecordThread(qrk::Connection* con, const char* fileName);
  ~RecordThread(void);
  void run(void);
  void stop(void);

  int count(void);
};

#endif /* !RECORD_THREAD_H */
