/*!
  \file
  \brief ログデータの記録スレッド

  \author Satofumi KAMIMURA

  $Id: RecordThread.cpp 203 2008-09-03 02:44:24Z satofumi $
*/

#include "RecordThread.h"
#include "Connection.h"
#include "ConnectionUtils.h"
#include <QMutex>
#include <fstream>

using namespace qrk;


struct RecordThread::pImpl
{
  enum {
    Timeout = 1000,
    BufferSize = 256,
  };

  Connection* con_;
  std::ofstream fout_;
  QMutex mutex_;
  bool stop_;

  int count_;


  pImpl(Connection* con, const char* file_name)
  : con_(con), stop_(false), count_(0)
  {
    fout_.open(file_name);
    if (fout_.is_open()) {
      // !!! 例外を投げる
    }
  }


  void record(void)
  {
    char buffer[BufferSize];

    count_ = 0;

    mutex_.lock();
    bool thread_stop = stop_;
    mutex_.unlock();
    while (! stop_) {
      int n = readline(con_, buffer, BufferSize, Timeout);
      if (n >= 0) {
        fout_.write(buffer, n);
        fout_ << std::endl;
        fout_.flush();
        ++count_;
      }

      mutex_.lock();
      thread_stop = stop_;
      mutex_.unlock();
    }
    fout_.close();

    con_->send("QT\r", 3);
    skip(con_, Timeout);
  }
};


RecordThread::RecordThread(Connection* con, const char* fileName)
  : pimpl(new pImpl(con, fileName))
{
}


RecordThread::~RecordThread(void)
{
}


void RecordThread::run(void)
{
  pimpl->mutex_.lock();
  pimpl->stop_ = false;
  pimpl->mutex_.unlock();

  pimpl->record();
}


void RecordThread::stop(void)
{
  pimpl->mutex_.lock();
  pimpl->stop_ = true;
  pimpl->mutex_.unlock();
}


int RecordThread::count(void)
{
  pimpl->mutex_.lock();
  int count = pimpl->count_;
  pimpl->mutex_.unlock();

  return count;
}
