#ifndef URG_LOG_HANDLER_H
#define URG_LOG_HANDLER_H

/*!
  \file
  \brief URG の出力ログ管理

  \author Satofumi KAMIMURA

  $Id: UrgLogHandler.h 157 2008-08-20 05:47:02Z satofumi $

  \todo get*() 形式のメソッドを *() 形式に変更する
*/

#include "GridTypes.h"
#include <vector>
#include <memory>


class UrgLogHandler
{
  UrgLogHandler(const UrgLogHandler& rhs);
  UrgLogHandler& operator = (const UrgLogHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  UrgLogHandler(void);
  ~UrgLogHandler(void);

  //! ログ記録の開始
  bool create(const char* file_name);

  //! データ追加
  void addData(size_t timestamp, const std::vector<qrk::Grid<int> >& points);

  //! 内容を書き出して終了
  void close();

  //! 読み出すファイルを指定
  bool load(const char* file_name);

  //! 最終タイムスタンプの取得
  int getLastTimestamp(void);

  //! データの読み出し
  bool getData(size_t& timestamp, std::vector<qrk::Grid<int> >& points,
               size_t current_timestamp);
};

#endif /* !URG_LOG_HANDLER_H */
