#ifndef DRAW_3D_WIDGET_H
#define DRAW_3D_WIDGET_H

/*!
  \file
  \brief URG データの表示ウィジット

  \author Satofumi KAMIMURA

  $Id: Draw3DWidget.h 157 2008-08-20 05:47:02Z satofumi $
*/

#include "GridTypes.h"
#include <QGLWidget>


class Draw3DWidget : public QGLWidget {
  Q_OBJECT;

  Draw3DWidget(const Draw3DWidget& rhs);
  Draw3DWidget& operator = (const Draw3DWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);

public:
  Draw3DWidget(QGLWidget* parent = 0);
  ~Draw3DWidget(void);

  //! 再描画
  void redraw(size_t timestamp, const qrk::Grid3D<int>& draw_position);

  void setDrawLineData(const std::vector<qrk::Grid<int> >& draw_points, int h);

  //! 表示データのクリア
  void clear(void);

  //! 表示データの追加
  void addData(size_t timestamp,
               const std::vector<qrk::Grid3D<int> >& points);

  void addAdditionalData(size_t timestamp,
               const std::vector<qrk::Grid3D<int> >& points);

  //! データを表示する期間の設定
  void setDrawPeriod(size_t msec);

  //! データ表示角度の指定
  void setViewRotation(const qrk::Grid3D<int>& rotation);
  void viewUp(void);
  void viewDown(void);
  void viewLeft(void);
  void viewRight(void);
  qrk::Grid3D<int> viewRotation(void);

  //! 拡大率の指定
  void setViewZoom(const double ratio);
  void zoomIn(void);
  void zoomOut(void);
  double zoomRatio(void);
};

#endif /* !DRAW_3D_WIDGET_H */
