#ifndef VIEW_CONTROL_WIDGET_H
#define VIEW_CONTROL_WIDGET_H

/*!
  \file
  \brief 視点の操作ウィジット

  \author Satofumi KAMIMURA

  $Id: ViewControlWidget.h 198 2008-09-02 05:24:11Z satofumi $
*/

#include "ui_ViewControlWidgetForm.h"


class ViewControlWidget : public QWidget, private Ui::ViewControlWidgetForm
{
  Q_OBJECT;

  ViewControlWidget(const ViewControlWidget& rhs);
  ViewControlWidget& operator = (const ViewControlWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectUrg(void);
  void disconnectUrg(void);
  void capture(void);
  void zoomChanged(int value);

public:
  ViewControlWidget(QWidget* parent = 0);
  ~ViewControlWidget(void);

  void updatePorts(const std::vector<std::string>& ports, int defaultIndex);

  bool isConnected(void);

  int zoomPercent(void);
  void setZoomPercent(int percent);

public slots:
  void redraw(void);
};

#endif /* !VIEW_CONTROL_WIDGET_H */
